package edu.uky.ai.lp.logic;

/**
 * Represents an expression with 1 or more conjuncts which must all be true.
 * 
 * @author Stephen G. Ware
 */
public class Conjunction extends NAryBooleanExpression {
	
	/**
	 * Constructs a new conjunction with the given arguments.
	 * 
	 * @param conjuncts the conjuncts
	 */
	public Conjunction(Expression...conjuncts) {
		super("and", conjuncts);
	}

	@Override
	public String toString() {
		return toString(", ");
	}
	
	@Override
	public Conjunction substitute(Unifier unifier) {
		return new Conjunction(substituteArguments(unifier));
	}
}
